<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {!! SEO::generate() !!}

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{asset('css/animate.css')}}">
    <link rel="stylesheet" href="{{asset('css/magnific-popup.css')}}">
    <link rel="stylesheet" href="{{asset('css/slick.css')}}">
    <link rel="stylesheet" href="{{asset('css/LineIcons.2.0.css')}}">
    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js" defer></script>
</head>

<body>
    <div class="hidden preloader">
        <div class="loader">
            <div class="ytp-spinner">
                <div class="ytp-spinner-container">
                    <div class="ytp-spinner-rotator">
                        <div class="ytp-spinner-left">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                        <div class="ytp-spinner-right">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--====== PRELOADER PART ENDS ======-->

    <!--====== HEADER PART START ======-->

    <header class="header-area">
        <div class="navbar-area">
            <div class="container relative">
                <div class="row">
                    <div class="w-full">
                        <nav class="flex items-center justify-between navbar navbar-expand-lg">
                            <a class="mr-4 navbar-brand" href="/">
                                <img class="h-12" src="{{asset('images/logo.png')}}" alt="Adamant Logo">
                            </a>
                            <button class="block navbar-toggler focus:outline-none lg:hidden" type="button"
                                data-toggle="collapse" data-target="#navbarOne" aria-controls="navbarOne"
                                aria-expanded="false" aria-label="Toggle navigation">
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                            </button>


                            <div class="absolute left-0 z-20 hidden w-full px-5 py-3 duration-300 bg-white shadow lg:w-auto collapse navbar-collapse lg:block top-100 mt-full lg:static lg:bg-transparent lg:shadow-none"
                                id="navbarOne">
                                <ul id="nav"
                                    class="items-center content-start mr-auto lg:justify-end navbar-nav lg:flex">
                                    <li class="nav-item active">
                                        <a class="page-scroll" href="{{ url('/') }}">Home</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="{{route('shopship')}}">Shop & Ship</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="{{route('services')}}">Services</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="{{route('press')}}">News Feed</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="{{route('contact')}}">Contact</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="{{route('about')}}">About</a>
                                    </li>
                                </ul>
                            </div> <!-- navbar collapse -->

                            <div
                                class="absolute right-0 hidden mt-2 mr-24 navbar-btn sm:inline-block lg:mt-0 lg:static lg:mr-0">
                                <a class="main-btn gradient-btn" data-scroll-nav="0" href="#" rel="nofollow">Get
                                    Quote</a>
                            </div>
                        </nav> <!-- navbar -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
        </div> <!-- navbar area -->
    </header>

    <!-- Page Content -->
    <main>
        {{ $slot }}
    </main>
    <footer class="relative z-10 footer-area pt-120">
        <div class="footer-bg bg-black"></div>
        <div class="max-w-screen-2xl mx-auto px-3">
            <div class="footer-widget pb-120">
                <div class="row">
                    <div class="w-full md:w-3/5 lg:w-2/6">
                        <div class="mt-12 footer-about wow fadeIn" data-wow-duration="1s" data-wow-delay="0.2s">
                            <a class="inline-block mb-8 logo" href="index.html">
                                <img src="{{asset('images/logo.png')}}" alt="Adamant Logistics logo" class="h-12">
                            </a>
                            <p class="pb-10 pr-10 leading-snug text-white">Logistics is an integrated end to end
                                logistics service provider. We plan, implement and operate complex supply
                                chain solutions on a national, regional and global scale on behalf of medium to
                                large corporate firms.</p>
                            <ul class="flex footer-social">
                                <li><a
                                        href="https://www.facebook.com/pages/category/Business-Service/Adamant-Logistics-Solutions-Ltd-105929314257431/"><i
                                            class="lni lni-facebook-filled"></i></a></li>
                                <li><a href="https://twitter.com/adamantlogistic"><i
                                            class="lni lni-twitter-filled"></i></a></li>
                                <li><a
                                        href="https://ke.linkedin.com/company/adamant-logistics-solutions?trk=public_profile_topcard_current_company"><i
                                            class="lni lni-linkedin-original"></i></a></li>
                            </ul>
                        </div> <!-- footer about -->
                    </div>
                    <div class="w-4/5 sm:w-2/3 md:w-3/5 lg:w-2/6">
                        <div class="row">
                            <div class="w-full sm:w-1/2 md:w-1/2 lg:w-1/2">
                                <div class="mt-12 link-wrapper wow fadeIn" data-wow-duration="1s" data-wow-delay="0.4s">
                                    <div class="footer-title">
                                        <h4 class="mb-8 text-2xl font-bold text-white">Quick Link</h4>
                                    </div>
                                    <ul class="link">
                                        <li><a href="/">About Us</a></li>
                                        <li><a href="/">Contact Us</a></li>
                                        <li><a href="/">Press</a></li>
                                        <li><a href="/">Terms of Service</a></li>
                                        <li><a href="/">Privacy Policy</a></li>
                                    </ul>
                                </div> <!-- footer wrapper -->
                            </div>
                            <div class="w-full sm:w-1/2 md:w-1/2 lg:w-1/2">
                                <div class="mt-12 link-wrapper wow fadeIn" data-wow-duration="1s" data-wow-delay="0.6s">
                                    <div class="footer-title">
                                        <h4 class="mb-8 text-2xl font-bold text-white">Services</h4>
                                    </div>
                                    <ul class="link">
                                        <li><a href="#">Refrigerated Trucks</a></li>
                                        <li><a href="#">Transport and Distribution</a></li>
                                        <li><a href="#">Supply Consultancy</a></li>
                                        <li><a href="#">Air Freight</a></li>
                                        <li><a href="#">Sea Freight</a></li>
                                    </ul>
                                </div> <!-- footer wrapper -->
                            </div>
                        </div>
                    </div>
                    <div class="w-4/5 sm:w-1/3 md:w-2/5 lg:w-2/6">
                        <div class="mt-12 footer-contact wow fadeIn" data-wow-duration="1s" data-wow-delay="0.8s">
                            <div class="footer-title">
                                <h4 class="mb-8 text-2xl font-bold text-white">Contact Us</h4>
                            </div>
                            <ul class="contact">
                                <li>0113 962284</li>
                                <li>info@adamant.co.ke</li>
                                <li>adamant.co.ke</li>
                                <li>2nd Floor, Pili Trade Center, along Mombasa Road, Nairobi, Kenya.</li>
                            </ul>
                        </div> <!-- footer contact -->
                    </div>
                </div> <!-- row -->
            </div> <!-- footer widget -->
            <div class="py-8 border-t border-gray-200 footer-copyright">
                <p class="text-white">&copy;
                    <?php echo date("Y");?> All Rights Reserved by
                    <a class="duration-300 hover:text-theme-color-2" href="{{ url('/') }}">{{ config('app.name',
                        'Adamant Logistics')
                        }}</a>
                </p>
            </div> <!-- footer copyright -->
        </div> <!-- container -->
        <div id="particles-2" class="particles"></div>
    </footer>
    <a href="#" class="back-to-top"><i class="lni lni-chevron-up"></i></a>
</body>

</html>
