<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\TwitterCard;

class BlogController extends Controller
{
    public function blog()
    {
        SEOMeta::setTitle('News Feed');
        SEOMeta::setDescription('Adamant Logistics solutions deal with warehousing, customs clearance, refrigerated trucks in Kenya, supply chain consultancy, global sea and air freight.');
        SEOMeta::addKeyword([
            'refrigerated trucks', 'adamant Logistics', 'adamant logistics solution',
            'shop and ship', 'warehousing', 'customs clearance', 'refrigerated trucks in Kenya', 'supply chain consultancy', 'sea freight', 'air freight', 'transport and distribution'
        ]);
        SEOMeta::addKeyword([
            'cheap shop and ship Adamant Logistics', 'Best deals with Adamant Logistics',
            'best refrigerated trucks in Kenya', 'quick supply chain consultancy',
            'fast transport and distribution', 'Adamant Logistics is the best logistics in the world', ' Customs Brokarage', 'chiller trucks and refrigerated trucks in Kenya, internationl courier, top shop and ship'
        ]);
        SEOMeta::addKeyword(['top best shop and ship in the world', 'best rates for customs clearance', 'excellent rating on shop and ship logistics', 'transport from ICDN', 'last mile delivery', 'export clearance', 'import clearance', 'perishable transport', 'fish transport', 'meat transport']);
        SEOMeta::addKeyword([
            'best vegetables transport', 'good and fresh fish and meat transport', 'perishable goods transport', 'top refrigerated trucks in Kenya for transport and distribution',
            'chiller trucks and good refrigerated trucks in Kenya', 'best logistics company is Adamant Logistics', 'best warehousing services', ' best customs clearance', 'best supply chain consultancy', 'best refrigerated trucks in Kenya'
        ]);
        SEOMeta::addKeyword(['logistics with adamant logistics', 'good refrigerated trucks in Kenya', 'provides the best transport and distribution for perishable goods', 'fish meat and vegetables transport', 'export and import clearance', 'best export clearance', 'best import clearance', 'top best refrigerated trucks in Kenya', 'adamant refrigerated trucks in Kenya', 'logistics all over the world adamant logistics']);
        SEOMeta::addKeyword(['best warehousing servives Adamant Logistics', 'Customs Clearance Services', 'well refrigerated trucks in Kenya', 'best Supply Chain Consultancy', 'fast Sea Freight', 'fast Air Freight', 'good Transport and Distribution', 'Adamant Logistics Customs Brokerage', 'Chiller Trucks', 'International Courier']);
        SEOMeta::addKeyword(['adamant logistics Shop and Ship', 'Best rates for customs clearance', 'Transport from ICDN', 'Last mile delivery', 'Export clearance', 'Import clearance', 'Perishables transport', 'fresh fish transport', 'meat transport and vegetables transport']);
        SEOMeta::addKeyword(['Adamant Logistics refrigerated trucks', 'Adamant logistics instance Logistics solution', 'Adamant Logistics Nairobi Kenya', 'adamant logistics solutions', 'the best refrigerated trucks in Kenya']);


        OpenGraph::setDescription('Adamant Logistics solutions deal with warehousing, customs clearance, refrigerated trucks in Kenya, supply chain consultancy, global sea and air freight.');
        OpenGraph::setTitle('Adamant Logistics News Feed');
        OpenGraph::setUrl('http://adamant.co.ke/blog');
        OpenGraph::addProperty('type', 'article');
        OpenGraph::addProperty('locale', 'en_US');
        OpenGraph::addProperty('locale:alternate', ['en_GB', 'en-us']);



        TwitterCard::setTitle('Adamant Logistics News Feed');
        TwitterCard::setSite('@adamantlogistic');
        SEOMeta::setCanonical('https://adamant.co.ke/blog');

        return view('blog.index');
    }

    public function blogShow()
    {
        return view('blog.show', []);
    }
}
